<?php
// Include the QRcode library
include 'phpqrcode/qrlib.php';

// Function to generate QR code from URL
function generateQRCode($url, $filename = false, $size = 200) {
    // If no filename provided, generate a random one
    if (!$filename) {
        $filename = uniqid() . '.png';
    }
    
    // Generate QR code
    QRcode::png($url, $filename, QR_ECLEVEL_L, 10, 2);

    // Return filename of generated QR code
    return $filename;
}

// Example usage:
$url = 'https://crmsahavas.co.in/kanakveda/Book_An_Event.php?event_name=NHP%20School&&eventID=2'; // Replace with your URL
$filename = generateQRCode($url);
echo "QR code generated: $filename";
?>
